/*! For license information please see editor-elements.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/libs/editor-elements/src/errors.ts":function(e,t,n){n.r(t),n.d(t,{ElementIndexNotFoundError:function(){return l},ElementLabelNotExistsError:function(){return i},ElementNotFoundError:function(){return r},ElementParentNotFoundError:function(){return a},ElementTypeNotExistsError:function(){return c},StyleNotFoundError:function(){return o}});var s=n("@elementor/utils");const r=(0,s.createError)({code:"element_not_found",message:"Element not found."}),o=(0,s.createError)({code:"style_not_found",message:"Style not found."}),c=(0,s.createError)({code:"element_type_not_exists",message:"Element type does not exist."}),i=(0,s.createError)({code:"element_label_not_exists",message:"Element label does not exist."}),a=(0,s.createError)({code:"element_parent_not_found",message:"Element parent not found."}),l=(0,s.createError)({code:"element_index_not_found",message:"Element index not found."})},"./packages/packages/libs/editor-elements/src/hooks/use-element-children.ts":function(e,t,n){n.r(t),n.d(t,{useElementChildren:function(){return useElementChildren}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function useElementChildren(e,t){return(0,s.__privateUseListenTo)([(0,s.v1ReadyEvent)(),(0,s.commandEndEvent)("document/elements/create"),(0,s.commandEndEvent)("document/elements/delete"),(0,s.commandEndEvent)("document/elements/update"),(0,s.commandEndEvent)("document/elements/set-settings")],()=>{const n=(0,r.getContainer)(e);return Object.entries(t).reduce((e,[t,s])=>{const r=n?.children?.findRecursive?.(({model:e})=>e.get("elType")===t),o=r?.children??[];return e[s]=o.filter(({model:e})=>e.get("elType")===s).map(({id:e})=>({id:e})),e},{})},[e])}},"./packages/packages/libs/editor-elements/src/hooks/use-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{useElementEditorSettings:function(){return useElementEditorSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts");const useElementEditorSettings=e=>(0,s.__privateUseListenTo)((0,s.windowEvent)("elementor/element/update_editor_settings"),()=>(0,r.getElementEditorSettings)(e),[e])},"./packages/packages/libs/editor-elements/src/hooks/use-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{useElementInteractions:function(){return useElementInteractions}});var s=n("react"),r=n("@elementor/editor-v1-adapters"),o=n("./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts");const useElementInteractions=e=>{const[t,n]=(0,s.useState)(()=>(0,o.getElementInteractions)(e)??{version:1,items:[]});return(0,r.__privateUseListenTo)((0,r.windowEvent)("elementor/element/update_interactions"),()=>{const t=(0,o.getElementInteractions)(e);n(t??{version:1,items:[]})},[e]),t}},"./packages/packages/libs/editor-elements/src/hooks/use-element-setting.ts":function(e,t,n){n.r(t),n.d(t,{useElementSetting:function(){return useElementSetting},useElementSettings:function(){return useElementSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts");const useElementSetting=(e,t)=>(0,s.__privateUseListenTo)((0,s.commandEndEvent)("document/elements/set-settings"),()=>(0,r.getElementSetting)(e,t),[e,t]),useElementSettings=(e,t)=>(0,s.__privateUseListenTo)((0,s.commandEndEvent)("document/elements/set-settings"),()=>t.reduce((t,n)=>{const s=(0,r.getElementSetting)(e,n);return null!==s&&(t[n]=s),t},{}),[e,t.join(",")])},"./packages/packages/libs/editor-elements/src/hooks/use-parent-element.ts":function(e,t,n){n.r(t),n.d(t,{useParentElement:function(){return useParentElement}});var s=n("@elementor/editor-v1-adapters");function useParentElement(e){return(0,s.__privateUseListenTo)([(0,s.commandEndEvent)("document/elements/create")],()=>{if(!e)return null;const t=window,n=t?.elementor?.getContainer?.(e);return n?n.parent:null},[e])}},"./packages/packages/libs/editor-elements/src/hooks/use-selected-element.ts":function(e,t,n){n.r(t),n.d(t,{useSelectedElement:function(){return useSelectedElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function useSelectedElement(){const e=(0,s.__privateUseListenTo)([(0,s.commandEndEvent)("document/elements/select"),(0,s.commandEndEvent)("document/elements/deselect"),(0,s.commandEndEvent)("document/elements/select-all"),(0,s.commandEndEvent)("document/elements/deselect-all")],o.getSelectedElements),[t]=e,n=(0,r.getElementType)(t?.type);return 1===e.length&&n?{element:t,elementType:n}:{element:null,elementType:null}}},"./packages/packages/libs/editor-elements/src/link-restriction.ts":function(e,t,n){n.r(t),n.d(t,{getAnchoredAncestorId:function(){return getAnchoredAncestorId},getAnchoredDescendantId:function(){return getAnchoredDescendantId},getLinkInLinkRestriction:function(){return getLinkInLinkRestriction},isElementAnchored:function(){return isElementAnchored}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts");const o="a, [data-action-link]";function getLinkInLinkRestriction(e,t){const n=getAnchoredDescendantId(e);if(n)return{shouldRestrict:!0,reason:"descendant",elementId:n};const s=function checkForInlineLink(e,t){const n=getElementDOM(e);if(!n)return!1;if(n.matches(o))return!1;const s=t??(0,r.getElementSetting)(e,"link")?.value;if(s?.destination)return!1;return null!==n.querySelector(o)}(e,t);if(s)return{shouldRestrict:!0,reason:"descendant",elementId:e};const c=getAnchoredAncestorId(e);return c?{shouldRestrict:!0,reason:"ancestor",elementId:c}:{shouldRestrict:!1}}function getAnchoredDescendantId(e){const t=getElementDOM(e);if(!t)return null;for(const n of Array.from(t.querySelectorAll(o))){const t=findElementIdOf(n);if(t!==e)return t}return null}function getAnchoredAncestorId(e){const t=getElementDOM(e);if(!t||null===t.parentElement)return null;const n=t.parentElement.closest(o);return n?findElementIdOf(n):null}function isElementAnchored(e){const t=getElementDOM(e);return!!t&&(!!t.matches(o)||doesElementContainAnchor(t))}function doesElementContainAnchor(e){for(const t of Array.from(e.children))if(!isElementorElement(t)){if(t.matches(o))return!0;if(doesElementContainAnchor(t))return!0}return!1}function findElementIdOf(e){return e.closest("[data-id]")?.dataset.id||null}function getElementDOM(e){try{return(0,s.getContainer)(e)?.view?.el||null}catch{return null}}function isElementorElement(e){return e.hasAttribute("data-id")}},"./packages/packages/libs/editor-elements/src/styles/consts.ts":function(e,t,n){n.r(t),n.d(t,{ELEMENT_STYLE_CHANGE_EVENT:function(){return r},styleRerenderEvents:function(){return o}});var s=n("@elementor/editor-v1-adapters");const r="elementor/editor-v2/editor-elements/style",o=[(0,s.commandEndEvent)("document/elements/create"),(0,s.commandEndEvent)("document/elements/duplicate"),(0,s.commandEndEvent)("document/elements/import"),(0,s.commandEndEvent)("document/elements/paste"),(0,s.windowEvent)(r)]},"./packages/packages/libs/editor-elements/src/styles/create-element-style.ts":function(e,t,n){n.r(t),n.d(t,{createElementStyle:function(){return createElementStyle},shouldCreateNewLocalStyle:function(){return shouldCreateNewLocalStyle}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-styles"),o=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),i=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function createElementStyle({styleId:e,elementId:t,classesProp:n,label:a,meta:l,props:d,custom_css:m=null,additionalVariants:u=[]}){let p=e;return(0,i.mutateElementStyles)(t,e=>{p??=(0,r.generateId)(`e-${t}-`,Object.keys(e));const i=[{meta:l,props:d,custom_css:m},...u];return e[p]={id:p,label:a,type:"class",variants:i},function addStyleToClassesProp(e,t,n){const r=(0,o.getElementSetting)(e,t),i=s.classesPropTypeUtil.create(e=>[...e??[],n],{base:r});(0,c.updateElementSettings)({id:e,props:{[t]:i},withHistory:!1})}(t,n,p),e}),p}function shouldCreateNewLocalStyle(e){return!e?.styleId&&!e?.provider}},"./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts":function(e,t,n){n.r(t),n.d(t,{deleteElementStyle:function(){return deleteElementStyle}});var s=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function deleteElementStyle(e,t){(0,s.mutateElementStyles)(e,e=>(delete e[t],e))}},"./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts":function(e,t,n){n.r(t),n.d(t,{mutateElementStyles:function(){return mutateElementStyles}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-v1-adapters"),o=n("./packages/packages/libs/editor-elements/src/errors.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),i=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),a=n("./packages/packages/libs/editor-elements/src/styles/consts.ts");function mutateElementStyles(e,t){const n=(0,c.getContainer)(e);if(!n)throw new o.ElementNotFoundError({context:{elementId:e}});const l=Object.keys(n.model.get("styles")??{}),d=function mutateStyles(e,t){const n=structuredClone(e.model.get("styles"))??{},s=Object.entries(t(n)).map(([e,t])=>(t.variants=function removeEmptyVariants(e){return e.variants.filter(({props:e,custom_css:t})=>Object.keys(e).length>0||t?.raw)}(t),[e,t])).filter(([,e])=>!function isStyleEmpty(e){return 0===e.variants.length}(e)),r=Object.fromEntries(s);return e.model.set("styles",r),r}(n,t);return function clearRemovedClasses(e,{oldIds:t,newIds:n}){const r=t.filter(e=>!n.includes(e)),o=structuredClone(function getClassesProps(e){return Object.entries(e.settings.toJSON()).filter(e=>{const[,t]=e;return s.classesPropTypeUtil.isValid(t)})}(e));o.forEach(([,e])=>{e.value=e.value.filter(e=>!r.includes(e))}),(0,i.updateElementSettings)({id:e.id,props:Object.fromEntries(o),withHistory:!1})}(n,{oldIds:l,newIds:Object.keys(d)}),function notifyChanges(){(function dispatchChangeEvent(){window.dispatchEvent(new CustomEvent(a.ELEMENT_STYLE_CHANGE_EVENT))})(),(0,r.__privateRunCommandSync)("document/save/set-is-modified",{status:!0},{internal:!0})}(),d}},"./packages/packages/libs/editor-elements/src/styles/update-element-style.ts":function(e,t,n){n.r(t),n.d(t,{updateElementStyle:function(){return updateElementStyle}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-styles"),o=n("./packages/packages/libs/editor-elements/src/errors.ts"),c=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function updateElementStyle(e){(0,c.mutateElementStyles)(e.elementId,t=>{const n=t[e.styleId];if(!n)throw new o.StyleNotFoundError({context:{styleId:e.styleId}});const c=(0,r.getVariantByMeta)(n,e.meta),i=("custom_css"in e?e.custom_css:c?.custom_css)??null;return c?(c.props=(0,s.mergeProps)(c.props,e.props),c.custom_css=i?.raw?i:null):n.variants.push({meta:e.meta,props:e.props,custom_css:i}),t})}},"./packages/packages/libs/editor-elements/src/sync/create-element.ts":function(e,t,n){n.r(t),n.d(t,{createElement:function(){return createElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function createElement({containerId:e,model:t,options:n}){const o=(0,r.getContainer)(e);if(!o)throw new Error(`Container with ID "${e}" not found`);return(0,s.__privateRunCommandSync)("document/elements/create",{container:o,model:t,options:{edit:!1,...n}})}},"./packages/packages/libs/editor-elements/src/sync/create-elements.ts":function(e,t,n){n.r(t),n.d(t,{createElements:function(){return createElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),o=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),i=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const createElements=({elements:e,title:t,subtitle:n=(0,r.__)("Item added","elementor")})=>(0,s.undoable)({do:({elements:e})=>{const t=[];return e.forEach(e=>{const{options:n,...s}=e,r=(0,o.createElement)({...s,options:{...n,useHistory:!1}}),c=r.id;t.push({elementId:c,model:r.model?.toJSON()||{},createParams:{...e}})}),{createdElements:t}},undo:(e,{createdElements:t})=>{[...t].reverse().forEach(({elementId:e})=>{(0,c.deleteElement)({elementId:e,options:{useHistory:!1}})})},redo:(e,{createdElements:t})=>{const n=[];return t.forEach(({createParams:e,model:t})=>{const s=(0,o.createElement)({containerId:e.containerId,model:t,options:{...e.options,useHistory:!1}}).id,r=(0,i.getContainer)(s);r&&n.push({elementId:s,model:r.model.toJSON(),createParams:e})}),{createdElements:n}}},{title:t,subtitle:n})({elements:e})},"./packages/packages/libs/editor-elements/src/sync/delete-element.ts":function(e,t,n){n.r(t),n.d(t,{deleteElement:function(){return deleteElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function deleteElement({elementId:e,options:t={}}){const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with ID "${e}" not found`);return(0,s.__privateRunCommand)("document/elements/delete",{container:n,options:t})}},"./packages/packages/libs/editor-elements/src/sync/drop-element.ts":function(e,t,n){n.r(t),n.d(t,{dropElement:function(){return dropElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function dropElement({containerId:e,model:t,options:n}){const o=(0,r.getContainer)(e);if(!o)throw new Error(`Container with ID "${e}" not found`);return(0,s.__privateRunCommandSync)("preview/drop",{container:o,model:t,options:n})}},"./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts":function(e,t,n){n.r(t),n.d(t,{duplicateElement:function(){return duplicateElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function duplicateElement({elementId:e,options:t={}}){const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with ID "${e}" not found`);const o=n.view?._index??0,c=!1!==t.clone?o+1:void 0;return(0,s.__privateRunCommandSync)("document/elements/duplicate",{container:n,options:{at:c,edit:!1,...t}})}},"./packages/packages/libs/editor-elements/src/sync/duplicate-elements.ts":function(e,t,n){n.r(t),n.d(t,{duplicateElements:function(){return duplicateElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),o=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),i=n("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const duplicateElements=({elementIds:e,title:t,subtitle:n=(0,r.__)("Item duplicated","elementor"),onDuplicateElements:l,onRestoreElements:d})=>(0,s.undoable)({do:({elementIds:e})=>{l?.();return{duplicatedElements:e.reduce((e,t)=>{const n=(0,a.getContainer)(t);if(n?.parent){const n=(0,i.duplicateElement)({elementId:t,options:{useHistory:!1}});e.push({id:n.id,model:n.model.toJSON(),originalElementId:t,modelToRestore:n.model.toJSON(),parentContainerId:n.parent?.id,at:n.view?._index})}return e},[])}},undo:(e,{duplicatedElements:t})=>{d?.(),[...t].reverse().forEach(({id:e})=>{(0,c.deleteElement)({elementId:e,options:{useHistory:!1}})})},redo:(e,{duplicatedElements:t})=>{l?.();return{duplicatedElements:t.reduce((e,t)=>{if(t.modelToRestore&&t.parentContainerId){const n=(0,o.createElement)({containerId:t.parentContainerId,model:t.modelToRestore,options:{useHistory:!1,clone:!1,at:t.at}});e.push({id:n.id,model:n.model.toJSON(),originalElementId:t.originalElementId,modelToRestore:t.modelToRestore,parentContainerId:t.parentContainerId,at:t.at})}return e},[])}}},{title:t,subtitle:n})({elementIds:e})},"./packages/packages/libs/editor-elements/src/sync/generate-element-id.ts":function(e,t,n){n.r(t),n.d(t,{generateElementId:function(){return generateElementId}});const generateElementId=()=>{const e=window;return e.elementorCommon?.helpers?.getUniqueId?.()??`el-${Date.now()}-${Math.random().toString(36).substring(2,9)}`}},"./packages/packages/libs/editor-elements/src/sync/get-all-descendants.ts":function(e,t,n){function getAllDescendants(e){return[e,...(e.children??[]).flatMap(e=>getAllDescendants(e))]}n.r(t),n.d(t,{getAllDescendants:function(){return getAllDescendants}})},"./packages/packages/libs/editor-elements/src/sync/get-container.ts":function(e,t,n){n.r(t),n.d(t,{getContainer:function(){return getContainer},selectElement:function(){return selectElement}});var s=n("@elementor/editor-v1-adapters");function getContainer(e){const t=window,n=t.elementor?.getContainer?.(e);return n??null}const selectElement=e=>{try{const t=getContainer(e);(0,s.__privateRunCommand)("document/elements/select",{container:t})}catch{}}},"./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts":function(e,t,n){function getCurrentDocumentContainer(){const e=window;return e.elementor?.documents?.getCurrent?.()?.container??null}n.r(t),n.d(t,{getCurrentDocumentContainer:function(){return getCurrentDocumentContainer}})},"./packages/packages/libs/editor-elements/src/sync/get-current-document-id.ts":function(e,t,n){function getCurrentDocumentId(){const e=window;return e.elementor?.documents?.getCurrentId?.()??null}n.r(t),n.d(t,{getCurrentDocumentId:function(){return getCurrentDocumentId}})},"./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{getElementEditorSettings:function(){return getElementEditorSettings}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getElementEditorSettings(e){const t=(0,s.getContainer)(e);return t?.model.get("editor_settings")??{}}},"./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{getElementInteractions:function(){return getElementInteractions}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getElementInteractions(e){const t=(0,s.getContainer)(e),n=t?.model?.get("interactions");return"string"==typeof n?JSON.parse(n):n}},"./packages/packages/libs/editor-elements/src/sync/get-element-label.ts":function(e,t,n){n.r(t),n.d(t,{getElementLabel:function(){return getElementLabel}});var s=n("./packages/packages/libs/editor-elements/src/errors.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function getElementLabel(e){e||(e=(0,c.getSelectedElements)()?.[0]?.id);const t=(0,r.getContainer)(e),n=t?.model.get("widgetType")||t?.model.get("elType");if(!n)throw new s.ElementTypeNotExistsError({context:{elementId:e}});const i=(0,o.getWidgetsCache)()?.[n]?.title;if(!i)throw new s.ElementLabelNotExistsError({context:{elementType:n}});return i}},"./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts":function(e,t,n){n.r(t),n.d(t,{getElementSetting:function(){return getElementSetting},getElementSettings:function(){return getElementSettings}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const getElementSetting=(e,t)=>{const n=(0,s.getContainer)(e);return n?.settings?.get(t)??null},getElementSettings=(e,t)=>Object.fromEntries(t.map(t=>[t,getElementSetting(e,t)]))},"./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts":function(e,t,n){n.r(t),n.d(t,{getElementStyles:function(){return getElementStyles}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const getElementStyles=e=>{const t=(0,s.getContainer)(e);return t?.model.get("styles")||null}},"./packages/packages/libs/editor-elements/src/sync/get-element-type.ts":function(e,t,n){n.r(t),n.d(t,{getElementType:function(){return getElementType}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts");function getElementType(e){if(!e)return null;const t=(0,s.getWidgetsCache)(),n=t?.[e];return n?.atomic_controls&&n?.atomic_props_schema?{key:e,controls:n.atomic_controls,propsSchema:n.atomic_props_schema,dependenciesPerTargetMapping:n.dependencies_per_target_mapping??{},title:n.title,styleStates:n.atomic_style_states??[]}:null}},"./packages/packages/libs/editor-elements/src/sync/get-elements.ts":function(e,t,n){n.r(t),n.d(t,{getElements:function(){return getElements}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts");function getElements(e){const t=e?(0,s.getContainer)(e):(0,r.getCurrentDocumentContainer)();if(!t)return[];const n=[...t.model.get("elements")??[]].flatMap(e=>getElements(e.get("id")));return[t,...n]}},"./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts":function(e,t,n){function getSelectedElements(){const e=window;return(e.elementor?.selection?.getElements?.()??[]).reduce((e,t)=>{const n=t.model.get("widgetType")||t.model.get("elType");return n&&e.push({id:t.model.get("id"),type:n}),e},[])}n.r(t),n.d(t,{getSelectedElements:function(){return getSelectedElements}})},"./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts":function(e,t,n){function getWidgetsCache(){const e=window;return e?.elementor?.widgetsCache||null}n.r(t),n.d(t,{getWidgetsCache:function(){return getWidgetsCache}})},"./packages/packages/libs/editor-elements/src/sync/move-element.ts":function(e,t,n){n.r(t),n.d(t,{moveElement:function(){return moveElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function moveElement({elementId:e,targetContainerId:t,options:n={}}){const c=(0,o.getContainer)(e),i=(0,o.getContainer)(t);if(!c)throw new Error(`Element with ID "${e}" not found`);if(!i)throw new Error(`Target container with ID "${t}" not found`);const a=c.model.toJSON();(0,r.deleteElement)({elementId:e,options:{...n,useHistory:!1}});return(0,s.createElement)({containerId:t,model:a,options:{edit:!1,...n,useHistory:!1}})}},"./packages/packages/libs/editor-elements/src/sync/move-elements.ts":function(e,t,n){n.r(t),n.d(t,{moveElements:function(){return moveElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),o=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/move-element.ts");const moveElements=({moves:e,title:t,subtitle:n=(0,r.__)("Elements moved","elementor"),onMoveElements:i,onRestoreElements:a})=>(0,s.undoable)({do:({moves:e})=>{const t=[];return i?.(),e.forEach(e=>{const{elementId:n}=e,s=(0,o.getContainer)(n);if(!s)throw new Error(`Element with ID "${n}" not found`);const r={elementId:n,originalContainerId:s.parent?.id||"",originalIndex:s.parent?.children?.indexOf(s)??-1},i=(0,c.moveElement)({...e,options:{...e.options,useHistory:!1}});t.push({elementId:n,originalPosition:r,move:e,element:i})}),{movedElements:t}},undo:(e,{movedElements:t})=>{a?.(),[...t].reverse().forEach(({originalPosition:e})=>{const{elementId:t,originalContainerId:n,originalIndex:s}=e;(0,c.moveElement)({elementId:t,targetContainerId:n,options:{useHistory:!1,at:s>=0?s:void 0}})})},redo:(e,{movedElements:t})=>{const n=[];return i?.(),t.forEach(({move:e,originalPosition:t})=>{const s=(0,c.moveElement)({...e,options:{...e.options,useHistory:!1}});n.push({elementId:e.elementId,originalPosition:t,move:e,element:s})}),{movedElements:n}}},{title:t,subtitle:n})({moves:e})},"./packages/packages/libs/editor-elements/src/sync/remove-elements.ts":function(e,t,n){n.r(t),n.d(t,{removeElements:function(){return removeElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),o=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),i=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const removeElements=({elementIds:e,title:t,subtitle:n=(0,r.__)("Item removed","elementor"),onRemoveElements:a,onRestoreElements:l})=>(0,s.undoable)({do:({elementIds:e})=>{const t=[];return e.forEach(e=>{const n=(0,i.getContainer)(e);if(n){const s=n.model.toJSON(),r=n.parent,o=n.view?._index??0;t.push({elementId:e,model:s,parent:r??null,at:o})}}),a?.(),e.forEach(e=>{(0,c.deleteElement)({elementId:e,options:{useHistory:!1}})}),{elementIds:e,removedElements:t}},undo:(e,{removedElements:t})=>{l?.(),[...t].reverse().forEach(({model:e,parent:t,at:n})=>{t&&e&&(0,o.createElement)({containerId:t.id,model:e,options:{useHistory:!1,at:n}})})},redo:(e,{elementIds:t,removedElements:n})=>(a?.(),t.forEach(e=>{(0,c.deleteElement)({elementId:e,options:{useHistory:!1}})}),{elementIds:t,removedElements:n})},{title:t,subtitle:n})({elementIds:e})},"./packages/packages/libs/editor-elements/src/sync/replace-element.ts":function(e,t,n){n.r(t),n.d(t,{replaceElement:function(){return replaceElement}});var s=n("./packages/packages/libs/editor-elements/src/errors.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const replaceElement=async({currentElement:e,newElement:t,withHistory:n=!0})=>{const{containerId:a,index:l}=function getNewElementContainer(e,t){const n=(0,c.getContainer)(e.id);if(!n)throw new s.ElementNotFoundError({context:{elementId:e.id}});const{parent:o}=n;if(!o)throw new s.ElementParentNotFoundError({context:{elementId:e.id}});const a=n.view?._index??0;if(-1===a)throw new s.ElementIndexNotFoundError({context:{elementId:e.id}});let l={containerId:o.id,index:a};"document"===o.id&&"widget"===t.elType&&(l=function createWrapperForWidget(e,t){const n=(0,r.createElement)({containerId:e,model:{elType:i},options:{at:t,useHistory:!1}});return{containerId:n.id,index:0}}(o.id,a));return l}(e,t),d=(0,r.createElement)({containerId:a,model:t,options:{at:l,useHistory:n}});return await(0,o.deleteElement)({elementId:e.id,options:{useHistory:n}}),d};const i="e-flexbox"},"./packages/packages/libs/editor-elements/src/sync/update-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{updateElementEditorSettings:function(){return updateElementEditorSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementEditorSettings=({elementId:e,settings:t})=>{const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with id ${e} not found`);const o=n.model.get("editor_settings")??{};n.model.set("editor_settings",{...o,...t}),function setDocumentModifiedStatus(e){(0,s.__privateRunCommandSync)("document/save/set-is-modified",{status:e},{internal:!0})}(!0)}},"./packages/packages/libs/editor-elements/src/sync/update-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{playElementInteractions:function(){return playElementInteractions},updateElementInteractions:function(){return updateElementInteractions}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementInteractions=({elementId:e,interactions:t})=>{const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with id ${e} not found`);n.model.set("interactions",t),window.dispatchEvent(new CustomEvent("elementor/element/update_interactions")),function setDocumentModifiedStatus(e){(0,s.__privateRunCommandSync)("document/save/set-is-modified",{status:e},{internal:!0})}(!0)},playElementInteractions=(e,t)=>{window.top?.dispatchEvent(new CustomEvent("atomic/play_interactions",{detail:{elementId:e,interactionId:t}}))}},"./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts":function(e,t,n){n.r(t),n.d(t,{updateElementSettings:function(){return updateElementSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementSettings=({id:e,props:t,withHistory:n=!0})=>{const o={container:(0,r.getContainer)(e),settings:{...t}};n?(0,s.__privateRunCommandSync)("document/elements/settings",o):(0,s.__privateRunCommandSync)("document/elements/set-settings",o,{internal:!0})}},"./packages/packages/libs/editor-elements/src/types.ts":function(e,t,n){n.r(t)},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-styles":function(e){e.exports=window.elementorV2.editorStyles},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(n){var s=t[n];if(void 0!==s)return s.exports;var r=t[n]={exports:{}};return e[n](r,r.exports,__webpack_require__),r.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n={};!function(){__webpack_require__.r(n),__webpack_require__.d(n,{ELEMENT_STYLE_CHANGE_EVENT:function(){return D.ELEMENT_STYLE_CHANGE_EVENT},createElement:function(){return c.createElement},createElementStyle:function(){return L.createElementStyle},createElements:function(){return i.createElements},deleteElement:function(){return a.deleteElement},deleteElementStyle:function(){return R.deleteElementStyle},dropElement:function(){return l.dropElement},duplicateElement:function(){return d.duplicateElement},duplicateElements:function(){return m.duplicateElements},generateElementId:function(){return u.generateElementId},getAllDescendants:function(){return v.getAllDescendants},getAnchoredAncestorId:function(){return N.getAnchoredAncestorId},getAnchoredDescendantId:function(){return N.getAnchoredDescendantId},getContainer:function(){return p.getContainer},getCurrentDocumentContainer:function(){return g.getCurrentDocumentContainer},getCurrentDocumentId:function(){return E.getCurrentDocumentId},getElementEditorSettings:function(){return _.getElementEditorSettings},getElementInteractions:function(){return H.getElementInteractions},getElementLabel:function(){return k.getElementLabel},getElementSetting:function(){return f.getElementSetting},getElementSettings:function(){return f.getElementSettings},getElementStyles:function(){return y.getElementStyles},getElementType:function(){return b.getElementType},getElements:function(){return w.getElements},getLinkInLinkRestriction:function(){return N.getLinkInLinkRestriction},getSelectedElements:function(){return I.getSelectedElements},getWidgetsCache:function(){return h.getWidgetsCache},isElementAnchored:function(){return N.isElementAnchored},moveElement:function(){return S.moveElement},moveElements:function(){return C.moveElements},playElementInteractions:function(){return M.playElementInteractions},removeElements:function(){return q.removeElements},replaceElement:function(){return T.replaceElement},selectElement:function(){return p.selectElement},shouldCreateNewLocalStyle:function(){return L.shouldCreateNewLocalStyle},styleRerenderEvents:function(){return D.styleRerenderEvents},updateElementEditorSettings:function(){return x.updateElementEditorSettings},updateElementInteractions:function(){return M.updateElementInteractions},updateElementSettings:function(){return A.updateElementSettings},updateElementStyle:function(){return O.updateElementStyle},useElementChildren:function(){return e.useElementChildren},useElementEditorSettings:function(){return t.useElementEditorSettings},useElementInteractions:function(){return P.useElementInteractions},useElementSetting:function(){return s.useElementSetting},useElementSettings:function(){return s.useElementSettings},useParentElement:function(){return r.useParentElement},useSelectedElement:function(){return o.useSelectedElement}});__webpack_require__("./packages/packages/libs/editor-elements/src/types.ts");var e=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-children.ts"),t=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-editor-settings.ts"),s=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-setting.ts"),r=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-parent-element.ts"),o=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-selected-element.ts"),c=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),i=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/create-elements.ts"),a=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),l=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/drop-element.ts"),d=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),m=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/duplicate-elements.ts"),u=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/generate-element-id.ts"),p=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),g=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts"),E=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-current-document-id.ts"),_=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts"),k=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-label.ts"),f=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),y=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts"),b=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts"),v=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-all-descendants.ts"),w=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-elements.ts"),I=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts"),h=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts"),S=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/move-element.ts"),C=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/move-elements.ts"),q=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/remove-elements.ts"),T=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/replace-element.ts"),x=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-editor-settings.ts"),A=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),N=__webpack_require__("./packages/packages/libs/editor-elements/src/link-restriction.ts"),D=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/consts.ts"),L=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/create-element-style.ts"),R=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts"),O=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/update-element-style.ts"),P=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-interactions.ts"),H=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts"),M=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-interactions.ts")}(),(window.elementorV2=window.elementorV2||{}).editorElements=n}(),window.elementorV2.editorElements?.init?.();
//# sourceMappingURL=editor-elements.js.map